//********************************************************************
//
//  Sample Program for Reader
//
//  Target Machine : CPT-711
//
//  Function:
//  void InitScanner1(void) : Initialize the scanner port.
//  void HaltScanner1(void) : Stop the scanner port from operating.
//  int  Decode(void)       : Perform barcode decoding.
//
//  SYNTECH INFORMATION CO., LTD.
//
//********************************************************************

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "..\lib\711lib.h"

void GetBcrData(void);

int  ibeep[4] = {16, 5, 0, 0};

unsigned char sDefaultBCR [23] = { 0x9b, 0xc9, 0x00, 0x00, 0x00, 0x21, 0x54,
                                   0x80, 0x00, 0x9d, 0x3d, 0x50, 0xc0, 0x01,
                                   0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0x66,
                                   0x03, 0x03 };

void main (void)
    {
    int  i;

    for (i=0; i<24; i++ )
        ScannerDesTbl[i] = sDefaultBCR[i];

    clr_scr();
    gotoxy (3, 0);  puts ("READING TEST");
    gotoxy (0, 2);  puts ("CODE:");
    gotoxy (0, 4);  puts ("TYPE:");
    gotoxy (0, 6);  puts ("LEN :");

    while (1)
        {
        InitScanner1();
        GetBcrData();
        OSTimeDly (4);
        }
    }

//***************************************************
// GetBcrData() : Get barcode data, type and length.
//***************************************************

void GetBcrData(void)
    {
    int x, y;

    while (1)
        {
        if (Decode ())
            {
            on_beeper (ibeep);
            HaltScanner1();

            for (y=2; y<7; y+=2)
                for (x=5; x<20; x++)
                    {
                    gotoxy (x, y);
                    putchar (0x20);
                    }

            gotoxy (5, 2);
            printf ("%s", CodeBuf);

            gotoxy (5, 4);
            switch (CodeType)
                {
                case 'A':
                     puts ("CODE39");
                     break;

                case 'B':
                     puts ("PHARMACODE");
                     break;

                case 'C':
                     puts ("CIP39");
                     break;

                case 'D':
                     puts ("INDUSTRIAL25");
                     break;

                case 'E':
                     puts ("INTERLEAVE25");
                     break;

                case 'F':
                     puts ("MATRIX25");
                     break;

                case 'G':
                     puts ("CODABAR");
                     break;

                case 'H':
                     puts ("CODE93");
                     break;

                case 'I':
                     puts ("CODE128");
                     break;

                case 'J':
                     puts ("UPCENA");
                     break;

                case 'K':
                     puts ("UPCEA2");
                     break;

                case 'L':
                     puts ("UPCEA5");
                     break;

                case 'M':
                     puts ("EAN8NA");
                     break;

                case 'N':
                     puts ("EAN8A2");
                     break;

                case 'O':
                     puts ("EAN8A5");
                     break;

                case 'P':
                     puts ("EAN13NA");
                     break;

                case 'Q':
                     puts ("EAN13A2");
                     break;

                case 'R':
                     puts ("EAN13A5");
                     break;

                case 'S':
                     puts ("MSI");
                     break;

                case 'T':
                     puts ("PLESSEY");
                     break;
                }

            gotoxy (5, 6);
            printf ("%d", CodeLen);
            return;
            }
        }
    }

//-------------------------------------------------------------------------//
